# 右连接

现有部门表

```sql
create table department(
    id int primary key auto_increment,
    name varchar(256)
)
```

和员工表

```sql
create table employee(
    id int primary key auto_increment,
    dept_id int,
    name varchar(256),
    post varchar(16)
)
```

公司经过了一轮调整后，员工信息有些混乱，现在 Joe 要写一个查询，找出部门信息写
错的员工，这些员工所在的部门在 department 表中没有对应记录。

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
select e.id, e.name, e.dept
from department as d
    right join employee as e on d.id = e.dept
where d.id is null;
```

## 选项

### A

```sql
select e.id, e.name, e.dept
from employee as e
    right join department as d on d.id = e.dept
where e.id is null;
```

### B

```sql
select e.id, e.name, e.dept
from employee as e
     right join department as d on d.id = e.dept
where d.id is null;
```

### C

```sql
select e.id, e.name, e.dept
from department as d
    join employee as e on d.id = e.dept
where d.id is null;
```


### D

```sql
select e.id, e.name, e.dept
from department as d
    right join employee as e on d.id = e.dept
where d.id is null;
```